/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.loot;

import com.autovw.advancednetherite.config.Config;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class CropDropsLootModifier
extends LootModifier {
    private final Item bonusDropItem;
    private final float bonusDropChance;
    private final int minDropAmount;
    private final int maxDropAmount;

    public CropDropsLootModifier(LootItemCondition[] conditionsIn, Item bonusDropItem, float bonusDropChance, int minDropAmount, int maxDropAmount) {
        super(conditionsIn);
        this.bonusDropItem = bonusDropItem;
        this.bonusDropChance = bonusDropChance;
        this.minDropAmount = minDropAmount;
        this.maxDropAmount = maxDropAmount;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        CropBlock cropBlock;
        Block block;
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (tool != null && blockState != null && ((Boolean)Config.AdditionalDropsConfig.enableAdditionalCropDrops.get()).booleanValue() && (double)this.bonusDropChance > 0.0 && this.bonusDropItem != null && (block = blockState.m_60734_()) instanceof CropBlock && (cropBlock = (CropBlock)block).m_52307_(blockState)) {
            Random random = context.m_78933_();
            if (this.maxDropAmount >= this.minDropAmount && random.nextFloat() <= this.bonusDropChance) {
                generatedLoot.add(new ItemStack((ItemLike)this.bonusDropItem, random.ints(this.minDropAmount, this.maxDropAmount + 1).iterator().nextInt()));
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<CropDropsLootModifier> {
        public CropDropsLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            JsonObject bonusDropObject = GsonHelper.m_13930_((JsonObject)object, (String)"bonus_drop");
            Item bonusDropItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)bonusDropObject, (String)"item")));
            float bonusDropChance = GsonHelper.m_13915_((JsonObject)bonusDropObject, (String)"chance");
            int minDropAmount = GsonHelper.m_13927_((JsonObject)bonusDropObject, (String)"min");
            int maxDropAmount = GsonHelper.m_13927_((JsonObject)bonusDropObject, (String)"max");
            return new CropDropsLootModifier(ailootcondition, bonusDropItem, bonusDropChance, minDropAmount, maxDropAmount);
        }

        public JsonObject write(CropDropsLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            JsonObject bonusDropObject = new JsonObject();
            object.add("bonus_drop", (JsonElement)bonusDropObject);
            bonusDropObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.bonusDropItem).toString());
            bonusDropObject.addProperty("chance", (Number)Float.valueOf(instance.bonusDropChance));
            bonusDropObject.addProperty("min", (Number)instance.minDropAmount);
            bonusDropObject.addProperty("max", (Number)instance.maxDropAmount);
            return object;
        }
    }
}

